/**
 * Admin JavaScript for Small Image
 *
 * @package WP_WebP_Optimizer
 */

(function($) {
	'use strict';

	/**
	 * Initialize when DOM is ready
	 */
	$(document).ready(function() {
		initQualitySlider();
	});

	/**
	 * Initialize quality slider functionality
	 */
	function initQualitySlider() {
		var $slider = $('#quality-slider');
		var $valueDisplay = $('.quality-value');

		if ($slider.length && $valueDisplay.length) {
			// Update display value when slider changes
			$slider.on('input change', function() {
				var value = $(this).val();
				$valueDisplay.text(value + '%');
				
				// Add visual feedback
				$valueDisplay.css('transform', 'scale(1.1)');
				setTimeout(function() {
					$valueDisplay.css('transform', 'scale(1)');
				}, 200);
			});
		}
	}

	/**
	 * Show confirmation when replacing originals
	 */
	var $replaceRadio = $('input[name="wp_webp_optimizer_settings[replace_original]"][value="replace"]');
	
	if ($replaceRadio.length) {
		$replaceRadio.on('change', function() {
			if ($(this).is(':checked')) {
				var confirmed = confirm(
					'Warning: This will permanently delete original JPEG/PNG files after conversion. ' +
					'Make sure you have backups of your important images.\n\n' +
					'Do you want to continue?'
				);
				
				if (!confirmed) {
					$('input[name="wp_webp_optimizer_settings[replace_original]"][value="keep_both"]').prop('checked', true);
				}
			}
		});
	}

	/**
	 * Add smooth transitions to settings changes
	 */
	$('.webp-optimizer-main input, .webp-optimizer-main select').on('change', function() {
		$(this).closest('tr').addClass('setting-changed');
		setTimeout(function() {
			$('.setting-changed').removeClass('setting-changed');
		}, 1000);
	});

})(jQuery);

